/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileRedstoneBlock;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockNpcRedstone
extends BlockInterface
implements IPermission {
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockNpcRedstone() {
        super(Material.field_151576_e);
        this.setName("npcredstoneblock");
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149647_a(CustomRegisters.tab);
    }

    public boolean func_149744_f(@Nonnull IBlockState state) {
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return new TileRedstoneBlock();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public int func_176211_b(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.isActivated(state);
    }

    public int func_180656_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.isActivated(state);
    }

    public int isActivated(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 15 : 0;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.SaveTileEntity;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_180639_a(@Nonnull World par1World, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem.func_77973_b() == CustomRegisters.wand && CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.EDIT_BLOCKS)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.RedstoneBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_176213_c(@Nonnull World par1World, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        par1World.func_175685_c(pos, (Block)this, false);
        par1World.func_175685_c(pos.func_177977_b(), (Block)this, false);
        par1World.func_175685_c(pos.func_177984_a(), (Block)this, false);
        par1World.func_175685_c(pos.func_177976_e(), (Block)this, false);
        par1World.func_175685_c(pos.func_177974_f(), (Block)this, false);
        par1World.func_175685_c(pos.func_177968_d(), (Block)this, false);
        par1World.func_175685_c(pos.func_177978_c(), (Block)this, false);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase entityliving, @Nonnull ItemStack item) {
        if (entityliving instanceof EntityPlayer && !world.field_72995_K) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entityliving, EnumGuiType.RedstoneBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_176206_d(@Nonnull World par1World, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.func_176213_c(par1World, pos, state);
    }
}

